#include "frame2.hpp" //Log is in the header.

Frame::Frame(Real radiusx, Real radiusy)
{
	_realradiusx = radiusx;
	_realradiusy = radiusy;
	//Force some numbers in to be safe; actually you'll
	//call SetPixelWindow again in the initial WM_SIZE with
	//the actual size of your active window.
	SetPixelWindow(640, 480);
	_changed_size_flag = TRUE;
	_fixed_aspect_flag = FALSE;
}

void Frame::SetPixelWindow(int cx, int cy)
{
	_cx = cx;
	_cy = cy;
	_midx = cx/2;
	_midy = cy/2;
	_realpixperx = (Real)_midx/_realradiusx; //RealToPixel uses this
	_realpixpery = (Real)_midy/_realradiusy; //speedier to precompute it.

	if (_fixed_aspect_flag)
	{
		if (_realpixperx < _realpixpery)
			_realpixpery = _realpixperx;
		else
			_realpixperx = _realpixpery;
	}
	_constx = _midx - _realcenterx * _realpixperx;
	_consty = _midy + _realcentery * _realpixpery;
	_changed_size_flag = TRUE;
}

void Frame::SetFixedAspect(BOOL truefalse)
{
	_fixed_aspect_flag = truefalse;
	SetPixelWindow(_cx, _cy);
}

void Frame::SetRealWindow(Real lox, Real loy, Real hix, Real hiy)
{
	_realcenterx = (lox + hix) / 2.0; //Average the values
	_realcentery = (loy + hiy) / 2.0; //Average to get the center.
	_realradiusx = hix - _realcenterx;
	_realradiusy = hiy - _realcentery;
	_realpixperx = (Real)_midx/_realradiusx; //RealToPixel uses this 
	_realpixpery = (Real)_midy/_realradiusy; //speedier to precompute it.

	if (_fixed_aspect_flag)
	{
		if (_realpixperx < _realpixpery)
			_realpixpery = _realpixperx;
		else
			_realpixperx = _realpixpery;
	}
	_constx = _midx - _realcenterx * _realpixperx;
	_consty = _midy + _realcentery * _realpixpery;
	_changed_size_flag = TRUE;
}

BOOL Frame::RealToPixel(Real rx, Real ry, int *ix, int *iy) const
{ //Designed to match the centers of the 2 windows even if _fixed_aspect_flag
//Use _realpixper? insetead of _mid?/_realradius? for speed.
//I can speed this up more by storing _midx -_realcenterx*_realpixperx
//as constx, and doing tempx = constx + rx*_realpixperx;  Will do later.
//I can speed this up using _constx = _midx -_realcenterx*_realpixperx
//as, and doing tempx = constx + rx*_realpixperx; and using
// _consty = _midy + _realcentery * _realpixpery   and doing
// tempy = _consty - ry * _realpixpery;

	Real tempx, tempy;
//	tempx = _midx + (rx - _realcenterx) * _realpixperx;
//	tempy = _midy - (ry - _realcentery) * _realpixpery;
	tempx = _constx + rx * _realpixperx;
	tempy = _consty - ry * _realpixpery;
	if (tempx > 32000.0 || tempy > 32000.0 || tempx < -32000.0 ||
		tempy < -32000.0)
		return FALSE; //integer would be out of range and meaningless.
	*ix = (int)tempx;
	*iy = (int)tempy;
	return TRUE;
}


void Frame::PixelToReal( int ix, int iy, Real *rx, Real *ry) const
{
	*rx = ((Real)(ix - _midx)/_realpixperx) + _realcenterx;
	*ry = ((Real)(_midy - iy)/_realpixpery) + _realcentery;
}


void Frame::Zoom(Real newcenterx, Real newcentery, Real zoomfactor)
{
	_realcenterx = newcenterx;
	_realcentery = newcentery;
	_realradiusx *= zoomfactor;
	_realradiusy *= zoomfactor;
	_realpixperx = (Real)_midx/_realradiusx; //RealToPixel uses this 
	_realpixpery = (Real)_midy/_realradiusy; //speedier to precompute it.
	if (_fixed_aspect_flag)
	{
		if (_realpixperx < _realpixpery)
			_realpixpery = _realpixperx;
		else
			_realpixperx = _realpixpery;
	}
	_constx = _midx - _realcenterx * _realpixperx;
	_consty = _midy + _realcentery * _realpixpery;
	_changed_size_flag = TRUE;
}

void Frame::ZoomAtPixel(int pixx, int pixy, Real zoomfactor)
{
	Real newcenterx, newcentery;
	PixelToReal(pixx, pixy, &newcenterx, &newcentery);
	Zoom(newcenterx, newcentery, zoomfactor);
}

void Frame::Scroll(Real percentx, Real percenty)
{	/*Move the center of RealWindow.  The percent? are between -1.0  and 1.0.
	The amount scrolled is equal the radius times the percent.*/
	Real newcenterx, newcentery;
	newcenterx = _realcenterx + percentx*_realradiusx;
	newcentery = _realcentery + percenty*_realradiusy;
	Zoom(newcenterx, newcentery, 1.0);
}